/*
 * Decompiled with CFR 0.152.
 */
package com.codenfast.updater.util;

import com.codenfast.updater.Log;
import com.codenfast.updater.util.FileUtil;
import com.codenfast.updater.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;

public final class LaunchUtil {
    public static final String LOCAL_JAVA_DIR = "java_vm";
    protected static boolean _isWindows;
    protected static boolean _isMacOS;
    protected static boolean _isLinux;

    public static boolean updateVersionAndRelaunch(File objectArray, String object, String string, String string2) throws IOException {
        Object object2 = new File((File)objectArray, "version.txt");
        object2 = new PrintStream(new FileOutputStream((File)object2));
        Object object3 = null;
        try {
            ((PrintStream)object2).println(string);
            ((PrintStream)object2).close();
        }
        catch (Throwable throwable) {
            try {
                object = throwable;
                object3 = throwable;
                throw object;
            }
            catch (Throwable throwable2) {
                if (object3 != null) {
                    try {
                        ((PrintStream)object2).close();
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object3).addSuppressed(throwable3);
                    }
                } else {
                    ((PrintStream)object2).close();
                }
                throw throwable2;
            }
        }
        object2 = new File((File)objectArray, (String)object);
        if (LaunchUtil.mustMonitorChildren() || !((File)object2).exists()) {
            return false;
        }
        object3 = StringUtil.isBlank(string2) ? LOCAL_JAVA_DIR : string2;
        object = LaunchUtil.getJVMBinaryPath(new File((File)objectArray, (String)object3), false);
        objectArray = new String[]{object, "-jar", ((File)object2).toString(), objectArray.getPath()};
        Log.log.info("Running " + StringUtil.join(objectArray, "\n  "), new Object[0]);
        try {
            Runtime.getRuntime().exec((String[])objectArray, null);
            return true;
        }
        catch (IOException iOException) {
            Log.log.warning("Failed to run updater", iOException);
            return false;
        }
    }

    public static String getJVMBinaryPath(File file, boolean bl) {
        String string = LaunchUtil.checkJVMPath(file.getAbsolutePath(), bl);
        if (string == null) {
            string = LaunchUtil.checkJVMPath(System.getProperty("java.home"), bl);
        }
        if (string == null) {
            Log.log.warning("Unable to find java [local=" + file + ", java.home=" + System.getProperty("java.home") + "]!", new Object[0]);
            string = "java";
        }
        if (LaunchUtil.isMacOS()) {
            try {
                file = new File("/usr/bin/java").getCanonicalFile();
                if (file.equals(new File(string).getCanonicalFile())) {
                    string = "/usr/bin/java";
                }
            }
            catch (IOException iOException) {
                Log.log.warning("Failed to check Mac OS canonical VM path.", iOException);
            }
        }
        return string;
    }

    public static void upgradeUpdater(File file, File file2, File file3) {
        if (!file3.exists() || file3.length() == file2.length()) {
            return;
        }
        Log.log.info("Updating Updater with " + file3 + "...", new Object[0]);
        if (file.exists()) {
            FileUtil.deleteHarder(file);
        }
        if (!file2.exists() || file2.renameTo(file)) {
            if (file3.renameTo(file2)) {
                FileUtil.deleteHarder(file);
                try {
                    FileUtil.copy(file2, file3);
                    return;
                }
                catch (IOException iOException) {
                    Log.log.warning("Error copying updated Updater back: " + iOException, new Object[0]);
                    return;
                }
            }
            Log.log.warning("Unable to renameTo(" + file + ").", new Object[0]);
            if (!file.renameTo(file2)) {
                Log.log.warning("Oh God, why dost thee scorn me so.", new Object[0]);
            }
        }
        Log.log.info("Attempting to upgrade by copying over " + file2 + "...", new Object[0]);
        try {
            FileUtil.copy(file3, file2);
            return;
        }
        catch (IOException iOException) {
            Log.log.warning("Mayday! Brute force copy method also failed.", iOException);
            return;
        }
    }

    public static boolean mustMonitorChildren() {
        String string = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        return string.contains("windows 98") || string.contains("windows me");
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isMacOS() {
        return _isMacOS;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    protected static String checkJVMPath(String string, boolean bl) {
        String string2 = (string = string + File.separator + "bin" + File.separator) + "java";
        if (new File(string2).exists()) {
            return string2;
        }
        if (!bl && new File(string2 = string + "javaw.exe").exists()) {
            return string2;
        }
        string2 = string + "java.exe";
        if (new File(string2).exists()) {
            return string2;
        }
        return null;
    }

    static {
        try {
            String string = System.getProperty("os.name");
            string = string == null ? "" : string;
            _isWindows = string.contains("Windows");
            _isMacOS = string.contains("Mac OS") || string.contains("MacOS");
            _isLinux = string.contains("Linux");
        }
        catch (Exception exception) {}
    }
}

