/*
 * Decompiled with CFR 0.152.
 */
package com.codenfast.updater.tools;

import com.codenfast.updater.Log;
import com.codenfast.updater.tools.JarDiffPatcher;
import com.codenfast.updater.tools.a;
import com.codenfast.updater.util.FileUtil;
import com.codenfast.updater.util.ProgressObserver;
import com.codenfast.updater.util.StreamUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Patcher {
    public static final String CREATE = ".create";
    public static final String PATCH = ".patch";
    public static final String DELETE = ".delete";
    protected ProgressObserver _obs;
    protected long _complete;
    protected long _plength;
    protected byte[] _buffer;
    protected static final int COPY_BUFFER_SIZE = 4096;

    public void patch(File file, File object, ProgressObserver object2) throws IOException {
        this._obs = object2;
        this._plength = ((File)object).length();
        object = new ZipFile((File)object);
        object2 = null;
        try {
            Enumeration<? extends ZipEntry> enumeration = ((ZipFile)object).entries();
            while (enumeration.hasMoreElements()) {
                Object object3 = enumeration.nextElement();
                String string = ((ZipEntry)object3).getName();
                long l2 = ((ZipEntry)object3).getCompressedSize();
                if (string.endsWith(CREATE)) {
                    string = this.strip(string, CREATE);
                    Log.log.info("Creating " + string + "...", new Object[0]);
                    this.createFile((ZipFile)object, (ZipEntry)object3, new File(file, string));
                } else if (string.endsWith(PATCH)) {
                    string = this.strip(string, PATCH);
                    Log.log.info("Patching " + string + "...", new Object[0]);
                    this.patchFile((ZipFile)object, (ZipEntry)object3, file, string);
                } else if (string.endsWith(DELETE)) {
                    string = this.strip(string, DELETE);
                    Log.log.info("Removing " + string + "...", new Object[0]);
                    object3 = new File(file, string);
                    if (!FileUtil.deleteHarder((File)object3)) {
                        Log.log.warning("Failure deleting '" + object3 + "'.", new Object[0]);
                    }
                } else {
                    Log.log.warning("Skipping bogus patch file entry: " + string, new Object[0]);
                }
                this._complete += l2;
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object2 = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                if (object2 != null) {
                    try {
                        ((ZipFile)object).close();
                    }
                    catch (Throwable throwable4) {
                        ((Throwable)object2).addSuppressed(throwable4);
                    }
                } else {
                    ((ZipFile)object).close();
                }
                throw throwable3;
            }
        }
        ((ZipFile)object).close();
        return;
    }

    protected String strip(String string, String string2) {
        return string.substring(0, string.length() - string2.length());
    }

    protected void createFile(ZipFile closeable, ZipEntry object, File file) {
        Object object2;
        if (this._buffer == null) {
            this._buffer = new byte[4096];
        }
        if (!((File)(object2 = file.getParentFile())).exists() && !((File)object2).mkdirs()) {
            Log.log.warning("Failed to create parent for '" + file + "'.", new Object[0]);
        }
        try {
            block24: {
                block22: {
                    closeable = ((ZipFile)closeable).getInputStream((ZipEntry)object);
                    object = null;
                    try {
                        object2 = new FileOutputStream(file);
                        Throwable throwable = null;
                        try {
                            int n2;
                            int n3 = 0;
                            while ((n2 = ((InputStream)closeable).read(this._buffer)) != -1) {
                                ((FileOutputStream)object2).write(this._buffer, 0, n2);
                                this.updateProgress(n3 += n2);
                            }
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                throwable = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                if (throwable != null) {
                                    try {
                                        ((FileOutputStream)object2).close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ((FileOutputStream)object2).close();
                                }
                                throw throwable4;
                            }
                        }
                        ((FileOutputStream)object2).close();
                        if (closeable == null) break block22;
                    }
                    catch (Throwable throwable) {
                        try {
                            object2 = throwable;
                            object = throwable;
                            throw object2;
                        }
                        catch (Throwable throwable6) {
                            if (closeable != null) {
                                if (object != null) {
                                    try {
                                        ((InputStream)closeable).close();
                                    }
                                    catch (Throwable throwable7) {
                                        ((Throwable)object).addSuppressed(throwable7);
                                    }
                                } else {
                                    ((InputStream)closeable).close();
                                }
                            }
                            throw throwable6;
                        }
                    }
                    break block24;
                }
                return;
            }
            ((InputStream)closeable).close();
        }
        catch (IOException iOException) {
            Log.log.warning("Error creating '" + file + "': " + iOException, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void patchFile(ZipFile closeable, ZipEntry object, File file, String object2) {
        File file2 = new File(file, (String)object2);
        File file3 = new File(file, ((ZipEntry)object).getName());
        file = new File(file, (String)object2 + ".old");
        object2 = null;
        FileUtil.deleteHarder(file);
        try {
            Object object3;
            closeable = ((ZipFile)closeable).getInputStream((ZipEntry)object);
            Throwable throwable2 = null;
            try {
                Throwable throwable;
                block23: {
                    object3 = new FileOutputStream(file3);
                    throwable = null;
                    StreamUtil.copy((InputStream)closeable, object3);
                    StreamUtil.close((OutputStream)object3);
                    if (FileUtil.renameTo(file2, file)) break block23;
                    Log.log.warning("Failed to .oldify '" + file2 + "'.", new Object[0]);
                    ((FileOutputStream)object3).close();
                    if (closeable == null) return;
                    ((InputStream)closeable).close();
                    return;
                }
                try {
                    long l2 = ((ZipEntry)object).getCompressedSize();
                    object = new a(this, l2);
                    object2 = new JarDiffPatcher();
                    ((JarDiffPatcher)object2).patchJar(file.getPath(), file3.getPath(), file2, (ProgressObserver)object);
                }
                catch (Throwable throwable3) {
                    try {
                        Throwable throwable4 = throwable3;
                        throwable = throwable3;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable != null) {
                            try {
                                ((FileOutputStream)object3).close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                                throw throwable5;
                            }
                        }
                        ((FileOutputStream)object3).close();
                        throw throwable5;
                    }
                }
                ((FileOutputStream)object3).close();
                if (closeable == null) return;
            }
            catch (Throwable throwable) {
                try {
                    object3 = throwable;
                    throwable2 = throwable;
                    throw object3;
                }
                catch (Throwable throwable8) {
                    if (closeable == null) throw throwable8;
                    if (throwable2 != null) {
                        try {
                            ((InputStream)closeable).close();
                            throw throwable8;
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                            throw throwable8;
                        }
                    }
                    ((InputStream)closeable).close();
                    throw throwable8;
                }
            }
            ((InputStream)closeable).close();
            return;
        }
        catch (IOException iOException) {
            if (object2 == null) {
                Log.log.warning("Failed to write patch file '" + file3 + "': " + iOException, new Object[0]);
                return;
            }
            Log.log.warning("Error patching '" + file2 + "': " + iOException, new Object[0]);
            return;
        }
        finally {
            FileUtil.deleteHarder(file3);
            FileUtil.deleteHarder(file);
        }
    }

    protected void updateProgress(int n2) {
        if (this._obs != null) {
            this._obs.progress((int)(100L * (this._complete + (long)n2) / this._plength));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: Patcher appdir patch_file");
            System.exit(-1);
        }
        Patcher patcher = new Patcher();
        try {
            patcher.patch(new File(stringArray[0]), new File(stringArray[1]), null);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Error: " + iOException.getMessage());
            System.exit(-1);
            return;
        }
    }
}

