/*
 * Decompiled with CFR 0.152.
 */
package com.codenfast.updater.launcher;

import com.codenfast.updater.Log;
import java.awt.Image;
import java.util.List;

public final class RotatingBackgrounds {
    protected long currentDisplayStart;
    protected int current = -1;
    protected Image[] images;
    protected Image errorImage;
    protected int[] percentages;
    protected int[] minDisplayTime;

    public RotatingBackgrounds() {
        this.makeEmpty();
    }

    public RotatingBackgrounds(Image image) {
        this.percentages = new int[]{0};
        this.minDisplayTime = new int[]{0};
        this.images = new Image[]{image};
        this.errorImage = this.images[0];
    }

    public RotatingBackgrounds(List<String> list, String string, ImageLoader imageLoader) {
        this.percentages = new int[list.size()];
        this.minDisplayTime = new int[list.size()];
        this.images = new Image[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            String string2 = list.get(n2);
            String[] stringArray = string2.split(";");
            if (stringArray.length != 2) {
                Log.log.warning("Unable to parse background image '" + string2 + "'", new Object[0]);
                this.makeEmpty();
                return;
            }
            this.images[n2] = imageLoader.loadImage(stringArray[0]);
            try {
                this.minDisplayTime[n2] = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                Log.log.warning("Unable to parse background image display time '" + string2 + "'", new Object[0]);
                this.makeEmpty();
                return;
            }
            int n3 = n2++;
            this.percentages[n3] = (int)((float)n3 / (float)list.size() * 100.0f);
        }
        if (string == null) {
            this.errorImage = this.images[0];
            return;
        }
        this.errorImage = imageLoader.loadImage(string);
    }

    public final Image getImage(int n2) {
        if (this.images.length == 0) {
            return null;
        }
        long l2 = System.currentTimeMillis();
        if (this.current != this.images.length - 1 && (this.current == -1 || n2 >= this.percentages[this.current + 1] && (l2 - this.currentDisplayStart) / 1000L > (long)this.minDisplayTime[this.current])) {
            ++this.current;
            this.currentDisplayStart = l2;
        }
        return this.images[this.current];
    }

    public final Image getErrorImage() {
        return this.errorImage;
    }

    public final int getNumImages() {
        return this.images.length;
    }

    protected final void makeEmpty() {
        this.percentages = new int[0];
        this.minDisplayTime = new int[0];
        this.images = new Image[0];
    }

    public static interface ImageLoader {
        public Image loadImage(String var1);
    }
}

