/*
 * Decompiled with CFR 0.152.
 */
package com.codenfast.updater.data;

import com.codenfast.updater.Log;
import com.codenfast.updater.data.Resource;
import com.codenfast.updater.data.SysProps;
import com.codenfast.updater.data.f;
import com.codenfast.updater.util.Config;
import com.codenfast.updater.util.MessageUtil;
import com.codenfast.updater.util.ProgressObserver;
import com.codenfast.updater.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class Digest {
    public static final int VERSION = 2;
    protected HashMap<String, String> _digests = new HashMap();
    protected String _metaDigest = "";
    protected static final String FILE_NAME = "digest";
    protected static final String FILE_SUFFIX = ".txt";

    public static String digestFile(int n2) {
        String string = n2 > 1 ? String.valueOf(n2) : "";
        return FILE_NAME + string + FILE_SUFFIX;
    }

    public static String sigAlgorithm(int n2) {
        switch (n2) {
            case 1: {
                return "SHA1withRSA";
            }
            case 2: {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Invalid digest version " + n2);
    }

    public static void createDigest(int n2, List<Resource> list, File object) throws IOException {
        Object object2;
        Object object4 = Executors.newFixedThreadPool(SysProps.threadPoolSize());
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        Object object5 = new LinkedBlockingQueue();
        long l2 = System.currentTimeMillis();
        Serializable serializable = new HashSet<Resource>(list);
        for (Resource object32 : list) {
            object4.execute(new f(n2, concurrentHashMap, object32, (BlockingQueue)object5));
        }
        object4.shutdown();
        try {
            while (serializable.size() > 0) {
                object2 = object5.poll(600L, TimeUnit.SECONDS);
                if (object2 instanceof IOException) {
                    throw (IOException)object2;
                }
                if (object2 instanceof Resource) {
                    serializable.remove(object2);
                    continue;
                }
                throw new AssertionError((Object)("What is this? " + object2));
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Timeout computing digests. Wow.");
        }
        object2 = new StringBuilder();
        FileOutputStream l3 = new FileOutputStream((File)object);
        Throwable throwable = null;
        try {
            object = new OutputStreamWriter((OutputStream)l3, StandardCharsets.UTF_8);
            object4 = null;
            try {
                object5 = new PrintWriter((Writer)object);
                serializable = null;
                try {
                    String string;
                    for (Resource resource : list) {
                        string = resource.getPath();
                        String string2 = (String)concurrentHashMap.get(resource);
                        Digest.note((StringBuilder)object2, string, string2);
                        ((PrintWriter)object5).println(string + " = " + string2);
                    }
                    MessageDigest throwable3 = Digest.getMessageDigest(n2);
                    byte[] byArray = ((StringBuilder)object2).toString().getBytes(StandardCharsets.UTF_8);
                    string = Digest.digestFile(n2);
                    ((PrintWriter)object5).println(string + " = " + StringUtil.hexlate(throwable3.digest(byArray)));
                    ((PrintWriter)object5).close();
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        serializable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (serializable != null) {
                            try {
                                ((PrintWriter)object5).close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)serializable).addSuppressed(throwable5);
                            }
                        } else {
                            ((PrintWriter)object5).close();
                        }
                        throw throwable4;
                    }
                }
            }
            catch (Throwable throwable4) {
                try {
                    object5 = throwable4;
                    object4 = throwable4;
                    throw object5;
                }
                catch (Throwable throwable7) {
                    if (object4 != null) {
                        try {
                            ((OutputStreamWriter)object).close();
                        }
                        catch (Throwable throwable8) {
                            ((Throwable)object4).addSuppressed(throwable8);
                        }
                    } else {
                        ((OutputStreamWriter)object).close();
                    }
                    throw throwable7;
                }
            }
            ((OutputStreamWriter)object).close();
        }
        catch (Throwable throwable5) {
            try {
                object = throwable5;
                throwable = throwable5;
                throw object;
            }
            catch (Throwable throwable10) {
                if (throwable != null) {
                    try {
                        l3.close();
                    }
                    catch (Throwable throwable11) {
                        throwable.addSuppressed(throwable11);
                    }
                } else {
                    l3.close();
                }
                throw throwable10;
            }
        }
        l3.close();
        long l4 = System.currentTimeMillis() - l2;
        Log.log.debug("Computed digests [rsrcs=" + list.size() + ", time=" + l4 + "ms]", new Object[0]);
    }

    public static MessageDigest getMessageDigest(int n2) {
        String string = n2 > 1 ? "SHA-256" : "MD5";
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("JVM does not support " + string + ". Gurp!");
        }
    }

    public Digest(File file, boolean bl) throws IOException {
        this(file, 2, bl);
    }

    public Digest(File object, int n2, boolean bl) throws IOException {
        String string = Digest.digestFile(n2);
        StringBuilder stringBuilder = new StringBuilder();
        object = new File((File)object, string);
        Config.ParseOpts parseOpts = Config.createOpts(false);
        Config.createOpts(false).strictComments = bl;
        parseOpts.biasToKey = true;
        for (String[] stringArray : Config.parsePairs((File)object, parseOpts)) {
            if (stringArray[0].equals(string)) {
                this._metaDigest = stringArray[1];
                break;
            }
            this._digests.put(stringArray[0], stringArray[1]);
            Digest.note(stringBuilder, stringArray[0], stringArray[1]);
        }
        object = Digest.getMessageDigest(n2);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
        if (!((String)(object = StringUtil.hexlate(((MessageDigest)object).digest(byArray)))).equals(this._metaDigest)) {
            object = MessageUtil.tcompose("m.invalid_digest_file", new String[]{this._metaDigest, object});
            throw new IOException((String)object);
        }
    }

    public String getMetaDigest() {
        return this._metaDigest;
    }

    public boolean validateResource(Resource resource, ProgressObserver object) {
        try {
            object = resource.computeDigest(2, Digest.getMessageDigest(2), (ProgressObserver)object);
            String string = this._digests.get(resource.getPath());
            if (((String)object).equals(string)) {
                return true;
            }
            Log.log.info("Resource failed digest check", "rsrc", resource, "computed", object, "expected", string);
        }
        catch (Throwable throwable) {
            Log.log.info("Resource failed digest check", "rsrc", resource, "error", throwable);
        }
        return false;
    }

    public String getDigest(Resource resource) {
        return this._digests.get(resource.getPath());
    }

    protected static void note(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string).append(" = ").append(string2).append("\n");
    }
}

