/*
 * Decompiled with CFR 0.152.
 */
package com.codenfast.updater.cache;

import com.codenfast.updater.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class ResourceCache {
    private final File _cacheDir;
    static final String LAST_ACCESSED_FILE_SUFFIX = ".lastAccessed";

    public ResourceCache(File file) throws IOException {
        this._cacheDir = file;
        this.createDirectoryIfNecessary(file);
    }

    private void createDirectoryIfNecessary(File file) throws IOException {
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("unable to create directory: " + file.getAbsolutePath());
        }
    }

    public File cacheFile(File file, String object, String object2) throws IOException {
        object = new File(this._cacheDir, (String)object);
        this.createDirectoryIfNecessary((File)object);
        object2 = new File((File)object, (String)object2 + this.getFileSuffix(file));
        object = new File((File)object, ((File)object2).getName() + LAST_ACCESSED_FILE_SUFFIX);
        if (!((File)object2).exists()) {
            this.createNewFile((File)object2);
            FileUtil.copy(file, (File)object2);
        }
        if (((File)object).exists()) {
            ((File)object).setLastModified(System.currentTimeMillis());
        } else {
            this.createNewFile((File)object);
        }
        return object2;
    }

    private void createNewFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("unable to create new file: " + file.getAbsolutePath());
        }
    }

    private String getFileSuffix(File object) {
        int n2 = ((String)(object = ((File)object).getName())).lastIndexOf(46);
        if (n2 >= 0) {
            return ((String)object).substring(n2);
        }
        return "";
    }
}

